/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.photoelectric.model.util;

import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.photoelectric.model.util.ScalarDataRecorder;

public class BeamIntensityMeter
extends ScalarDataRecorder {
    private int clientUpdateInterval = 500;
    private int simulationTimeWindow = 1000;

    public BeamIntensityMeter(IClock iClock) {
        super(iClock);
        super.setTimeWindow(this.simulationTimeWindow);
        super.setClientUpdateInterval(this.clientUpdateInterval);
    }

    public void recordPhoton() {
        this.recordPhotons(1);
    }

    public void recordPhotons(int n) {
        super.addDataRecordEntry(n);
    }

    public double getIntesity() {
        double d = this.getDataTotal() / this.getTimeSpanOfEntries();
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            d = 0.0;
        }
        return d;
    }
}

